

struct material
{
	vec3 diffuse;
	vec3 ambient;
	vec3 specular;
	float shininess;
};

#if defined(DAYTIME_NOON)
	#define GROUND_AMBIENT_BLUE 0.65
#else
	#define GROUND_AMBIENT_BLUE 0.50
#endif

#ifdef BLOOM_ACTIVATED
	#define GROUND_AMBIENT vec3(0.55, 0.55, GROUND_AMBIENT_BLUE)
#else
	#define GROUND_AMBIENT vec3(0.60, 0.60, GROUND_AMBIENT_BLUE*1.1)
#endif

material materialGround = material(
	vec3(0.6, 0.6, 0.6),
	GROUND_AMBIENT,
	vec3(0.20, 0.15, 0.10),
	4.0);


material materialWater = material(
	vec3(0.0, 0.0, 0.0),
	vec3(0.9, 0.9, 0.9),
	vec3(0.1, 0.1, 0.0),
	1.0);


#ifdef SPECULAR_MAP
	#define TREE_SPECULAR vec3(2.0,2.0,2.0)
#else
	#define TREE_SPECULAR vec3(0.3,0.3,0.1)
#endif

#if defined(DAYTIME_NOON)
	#define TREE_AMBIENT vec3(0.80, 0.80, 0.80)
#else
	#define TREE_AMBIENT vec3(0.92, 0.87, 0.80)
#endif

material materialTree = material(
	vec3(0.80, 0.80, 0.80),
	TREE_AMBIENT,
	TREE_SPECULAR,
	4.0);


material materialBuilding = material(
	vec3(0.5, 0.5, 0.5),
	vec3(0.7, 0.7, 0.7),
	vec3(0.1, 0.1, 0.05),
	1.0);

material materialCreature = material(
	vec3(0.5, 0.5, 0.5),
	vec3(0.7, 0.7, 0.7),
	vec3(0.0, 0.0, 0.0),
	1.0);


#if defined(MATERIAL_GROUND)
material currentMaterial = materialGround;
#elif defined(MATERIAL_WATER)
material currentMaterial = materialWater;
#elif defined(MATERIAL_VEGETATION)
material currentMaterial = materialTree;
#elif defined(MATERIAL_BUILDING)
material currentMaterial = materialBuilding;
#elif defined(MATERIAL_CREATURE)
material currentMaterial = materialCreature;
#endif



